#include <stdio.h>
#include <errno.h>
#include "event.h"

// Class Event
Event::Event()
{
	pthread_cond_init(&m_condition, NULL);
	pthread_mutex_init(&m_mutex, NULL);
}

Event::~Event()
{
	pthread_cond_destroy(&m_condition);
	pthread_mutex_destroy(&m_mutex);
}

Event::operator void*()
{
	return (void*) &m_condition;
}

bool Event::WaitForEvent(unsigned int timeout_ms)
{
	timespec ts;
	timeval now;
	gettimeofday(&now, NULL);
	
	unsigned int timeoutInSeconds = timeout_ms / 1000;
	ts.tv_sec  = now.tv_sec + timeoutInSeconds;
	ts.tv_nsec = now.tv_usec * 1000 + (ts.tv_nsec = (timeout_ms - timeoutInSeconds * 1000) * 1000000);
	ts.tv_sec += ts.tv_nsec / 1000000000;
	ts.tv_nsec = ts.tv_nsec % 1000000000;
	
	pthread_mutex_lock(&m_mutex);
	int result = ((timeout_ms == 0) ? pthread_cond_wait(&m_condition, &m_mutex) : pthread_cond_timedwait(&m_condition,  &m_mutex, &ts));
	pthread_mutex_unlock(&m_mutex);
	
	return (0 == result);
}

void Event::Signal()
{
	pthread_mutex_lock(&m_mutex);
	pthread_cond_signal(&m_condition);
	pthread_mutex_unlock(&m_mutex);
}

// Class EventSem
EventSem::EventSem()
{
	/* initialize m_semaphore -> no sharing (0), default locked (0) */
	int ret = sem_init(&m_semaphore, 0, 0);
	if (0 != ret)
		fprintf(stderr, "sem_init() returned with error -> errno: %d\n", errno);
}

EventSem::~EventSem()
{
	sem_post(&m_semaphore);
	int ret = sem_destroy(&m_semaphore);
	if (0 != ret)
		fprintf(stderr, "sem_destroy() returned with error -> errno: %d\n", errno);
}

EventSem::operator void*()
{
	return (void*) &m_semaphore;
}

bool EventSem::WaitForEvent(unsigned int timeout_ms)
{
	timespec ts;
	timeval now;
	gettimeofday(&now, NULL);
	int result = -1;

	unsigned int timeoutInSeconds = timeout_ms / 1000;
	ts.tv_sec  = now.tv_sec + timeoutInSeconds;
	ts.tv_nsec = now.tv_usec * 1000 + (ts.tv_nsec = (timeout_ms - timeoutInSeconds * 1000) * 1000000);
	ts.tv_sec += ts.tv_nsec / 1000000000;
	ts.tv_nsec = ts.tv_nsec % 1000000000;

	while (-1 == (result = ((0 == timeout_ms) ? sem_wait(&m_semaphore) : sem_timedwait(&m_semaphore, &ts))) && (EINTR == errno))
		continue;	/* Wait again when interrupted by a signal handler */

	if (0 != result)
		fprintf(stderr, "sem_wait() or sem_timedwait() returned with error -> errno: %d\n", errno);

	return (0 == result);
}

void EventSem::Signal()
{
	sem_post(&m_semaphore);
}
