#ifndef _EVENT_H_
#define _EVENT_H_

#include <semaphore.h>
#include <pthread.h>
#include <sys/time.h>

// Class 'Event' isn't async-signal-safe with libfcBase async-signal-handler!
// Use function fcbSetEventHandleV2() for class 'Event'.
class Event
{
	public:
		Event();
		~Event();
		operator void*();
		
		bool WaitForEvent(unsigned int timeout_ms = 0);
		void Signal();
		
	protected:
		pthread_mutex_t m_mutex;
		pthread_cond_t m_condition;
};

// Class 'EventSem' is async-signal-safe with libfcBase async-signal-handler!
// Use function fcbSetEventHandleSemaphore() for class 'EventSem'.
class EventSem
{
	public:
		EventSem();
		~EventSem();
		operator void*();

		bool WaitForEvent(unsigned int timeout_ms = 0);
		void Signal();

	protected:
		sem_t m_semaphore;
};

#endif /* _EVENT_H_ */
