///////////////////////////////////////////////////////////////////////////////
//! \file fcBasePMC.h:
//! \brief Header File for the fcBase PMC API.
//!
//! Use this header file for developing user defined FlexCard PMC applications.
//! See also printed documentation for more information. The data types and
//! enumerations can be found in the header file "fcBaseTypesPMC.h".
//!
//! Generally:
//!
//! - Each function of this library (except some error handling functions)
//!   returns an error code. If the return value is equal to 0, no error
//!   occurred. A number greater than 0 indicates an error. To get more
//!   information about it, use the error handling functions.
//!
//! \par Overview:
//! Author:         EBEL/WO/SH/Ba/TB/Tr/LJ
//! $Date: 2009-01-29 10:04:44 +0100 (Do, 29 Jan 2009) $ <br>
//! \par Copyright:
//! Copyright 2008-2009 Eberspaecher Electronics GmbH & Co. KG
//! \version $Revision: 14917 $
///////////////////////////////////////////////////////////////////////////////

#ifndef _FCBASE_PMC_H_
#define _FCBASE_PMC_H_

#ifndef _FCBASE_TYPES_H_
    #error Please include first the header file "fcBaseTypes.h"
#endif 

#ifndef _FCBASE_TYPES_PMC_H_
    #error Please include first the header file "fcBaseTypesPMC.h"
#endif 

// Linux
#ifdef linux
	#ifndef FCBASE_API
		#define FCBASE_API
	#endif
	//! Please do not use the FCBASE_EXPORTS define in your application, unless
	//! you have the source code ;-)
	#ifdef FCBASE_EXPORTS
		#define EXPORTDLL extern "C" __attribute__ ((visibility ("default")))
	#else
	    #define EXPORTDLL extern "C" 
	#endif

// Windows
#else

	#ifndef FCBASE_API
		#define FCBASE_API __stdcall
	#endif
	//! Please do not use the FCBASE_EXPORTS define in your application, unless
	//! you have the source code ;-)
	#ifdef FCBASE_EXPORTS
		#define EXPORTDLL       extern "C" __declspec(dllexport)
	#else
		#define EXPORTDLL       extern "C" __declspec(dllimport)
	#endif

#endif


//! Sets the transceiver mode individually for each channel.
//! \param hFlexCard	[IN] <br> Handle to a FlexCard
//! \param BusChannel	[IN] <br> The bus channel to terminate.
//! \param BusType		[IN] <br> The bus type termination. 
//! \param bTermination [IN] <br> A flag to enable the bus termination.
//! \return If the function succeeds, the return value is 0. If the value <> 0,
//!         please use the functions described in the section Error Handling to
//!         get extended error information. 
EXPORTDLL fcError FCBASE_API fcbSetBusTermination(fcHandle hFlexCard 
												, fcBusChannel BusChannel
												, fcBusType BusType
												, bool bTermination);


//! Reads the current bus termination setting.
//! \param hFlexCard [IN] <br> Handle to a FlexCard
//! \param hFlexCard	[IN] <br> Handle to a FlexCard
//! \param BusChannel	[IN] <br> The bus channel to terminate.
//! \param BusType		[IN] <br> The bus type termination. 
//! \param bTermination [OUT]<br> The current set bus termination enable flag. 0 = off , 1 = on
//! \return If the function succeeds, the return value is 0. If the value <> 0,
//!         please use the functions described in the section Error Handling to
//!         get extended error information. 
EXPORTDLL fcError FCBASE_API fcbGetBusTermination(fcHandle hFlexCard 
												, fcBusChannel BusChannel
												, fcBusType BusType
												, bool * pbTermination);

//! THIS FUNCTION IS OBSOLETE
//! This function allows to select one of the 2 available communication controllers
//! of the FlexCard PMC. Following called functions relate to this selected
//! communication controller.
//! \param hFlexCard [IN] <br> Handle to a FlexCard
//! \param ccIndex [IN] <br> The CC index to be set.
//! \return If the function succeeds, the return value is 0. If the value <> 0,
//!         please use the functions described in the section Error Handling to
//!         get extended error information. 
//! \see #fcbGetCcIndex
EXPORTDLL fcError FCBASE_API fcbSetCcIndex(fcHandle hFlexCard, 
                                           fcCC CCIndex);

//! THIS FUNCTION IS OBSOLETE
//! This function reads and returns the index of the selected communication 
//! controller.
//! \param hFlexCard [IN] <br> Handle to a FlexCard
//! \param pCcIndex [OUT] <br> The current selected CC index.
//! \return If the function succeeds, the return value is 0. If the value <> 0,
//!         use the functions described in the section Error Handling to
//!         get extended error information.
//! \see #fcbSetCcIndex
EXPORTDLL fcError FCBASE_API fcbGetCcIndex(fcHandle hFlexCard, 
                                           fcCC * pCCIndex);

#endif /* #define _FCBASE_PMC_H_ */
