///////////////////////////////////////////////////////////////////////////////
//! \file fcBaseTypesPMC.h:
//! \brief Header file for the data types and enumerations of the fcBase PMC API
//!
//! Use this header file for developing user defined FlexCard applications. This
//! header file contains all structures, data types and enumerations which are
//! used in the fcBase PMC API. For a description of the API function, please
//! refer to the header file "fcBasePMC.h".
//!
//! See also printed documentation for more information. 
//!  
//! \par Overview:
//! Author:         EBEL/WO/SH/Ba/TB/Tr/LJ
//! $Date: 2009-02-12 13:22:37 +0100 (Do, 12 Feb 2009) $ <br>
//! \par Copyright:
//! Copyright 2008-2009 Eberspaecher Electronics GmbH & Co. KG
//! \version $Revision: 14983 $
///////////////////////////////////////////////////////////////////////////////

#ifndef _FCBASE_TYPES_PMC_H_
#define _FCBASE_TYPES_PMC_H_

//-----------------------------------------------------------------------------
//           Initialization
//-----------------------------------------------------------------------------

//! This enumeration defines the available FlexCard bus channels. The values
//! fcBusChannel5 to fcBusChannel8 are only valid for the FlexCard PMC II.
typedef enum fcBusChannel
{
	fcBusChannel1 = 1,	//!< The bus channel 1 is selected.
	fcBusChannel2 = 2,	//!< The bus channel 2 is selected.
	fcBusChannel3 = 3,	//!< The bus channel 3 is selected.
	fcBusChannel4 = 4,	//!< The bus channel 4 is selected.
	fcBusChannel5 = 5,	//!< The bus channel 5 is selected.
	fcBusChannel6 = 6,	//!< The bus channel 6 is selected.
	fcBusChannel7 = 7,	//!< The bus channel 7 is selected.
	fcBusChannel8 = 8,	//!< The bus channel 8 is selected.
} fcBusChannel;

//-----------------------------------------------------------------------------
//          Configuration
//-----------------------------------------------------------------------------

//! This enumeration defines the conditions available for a trigger configuration.
typedef enum fcTriggerConditionPMC
{	
	fcTriggerPMCNone					= 0x00000000, //! Passive mode conditions: input trigger will create a trigger packet 
	fcTriggerPMCIn      				= 0x00000100, //! Passive mode conditions: input trigger will create a trigger packet 
	fcTriggerPMCOutOnPulse				= 0x00001000,
	fcTriggerPMCOutOnErrorDetected		= 0x00010000, //! Active mode conditions: output trigger is set if an error was detected
	fcTriggerPMCOutOnStartupCompleted	= 0x00020000, //! Active mode conditions: output trigger is set when the startup was completed
	fcTriggerPMCOutOnCycleStart			= 0x00100000,
} fcTriggerConditionPMC;

#endif /* #define _FCBASE_TYPES_PMC_H_ */
