///////////////////////////////////////////////////////////////////////////////
//! \file fcBaseFlexRay.h:
//! \brief Header File for the fcBase FlexRay API.
//!
//! Use this header file for developing user defined FlexCard applications.
//! See also printed documentation for more information. The common data types
//! and enumerations can be found in the header file "fcBaseTypes.h".
//! 
//! Generally:
//! 
//! - Each function of this library (except some error handling functions)
//!   returns an error code. If the return value is equal to 0, no error
//!   occurred. A number greater than 0 indicates an error. To get more
//!   information about it, use the error handling functions. 
//!
//! \par Overview:
//! Author:         EBEL/TB
//! $Date: 2008-09-24 13:10:02 +0200 (Mi, 24 Sep 2008) $ <br>
//! \par Copyright:
//! Copyright 2008 Eberspaecher Electronics GmbH & Co. KG
//! \version $Revision: 14159 $
///////////////////////////////////////////////////////////////////////////////

#ifndef _FCBASE_LINUX_H_
#define _FCBASE_LINUX_H_

#ifndef _FCBASE_TYPES_H_
	#error Please include first the header file "fcBaseTypes.h"
#endif 

#ifdef WIN32
	#error This header file must not be used for Windows systems. 
#endif

// Linux
#ifndef FCBASE_API
	#define FCBASE_API
#endif
//! Please do not use the FCBASE_EXPORTS define in your application, unless
//! you have the source code ;-)
#ifdef FCBASE_EXPORTS
	#define EXPORTDLL extern "C" __attribute__ ((visibility ("default")))
#else
	#define EXPORTDLL extern "C" 
#endif

//----------------------------------------------------------------------
//          Events
//----------------------------------------------------------------------

//! This function registers an event handle (as semaphore) for a specific
//! notification type. hEvent must be an unnamed POSIX semaphore from type
//! (sem_t).
//! \param hFlexCard [IN] <br> Handle to a FlexCard
//! \param CC [IN] <br> Index of the communication controller.
//! \param hEvent [IN] <br> Event handle to be registered to signal when a
//! 	   new cycle starts or a timer interval has elapsed depending on the
//! 	   given type.
//! \param type [IN] <br> The notification type for which the event has to be
//! 	   registered.
//! \return If the function succeeds, the return value is 0. If the value <> 0,
//!         use the functions described in the section Error Handling to get
//!         extended error information.
//! \note This feature is only supported/needed by the FlexCard Linux driver. 
//! \see #fcCC #fcNotificationType
#ifdef linux
	EXPORTDLL fcError FCBASE_API fcbSetEventHandleSemaphore(fcHandle hFlexCard,
															fcCC CC,
															fcHandle hEvent,
															fcNotificationType type);
#endif

#endif /* #define _FCBASE_LINUX_H_ */
